/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.styling;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.catalog.AbstractFileService;
import org.geotools.catalog.Catalog;
import org.geotools.catalog.GeoResource;
import org.geotools.catalog.ServiceInfo;
import org.geotools.catalog.defaults.DefaultServiceInfo;
import org.geotools.catalog.styling.SLDGeoResource;
import org.geotools.catalog.styling.SLDServiceFactory;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.util.ProgressListener;

public class SLDService
extends AbstractFileService {
    List members;

    public SLDService(Catalog parent, File file) {
        super(parent, file);
    }

    public boolean canResolve(Class adaptee) {
        if (adaptee == null) {
            return false;
        }
        if (adaptee.equals(StyledLayerDescriptor[].class)) {
            return true;
        }
        return super.canResolve(adaptee);
    }

    public Object resolve(Class adaptee, ProgressListener monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.equals(StyledLayerDescriptor[].class)) {
            List members = this.members(monitor);
            ArrayList<StyledLayerDescriptor> styles = new ArrayList<StyledLayerDescriptor>();
            for (GeoResource member : members) {
                StyledLayerDescriptor sld = (StyledLayerDescriptor)member.resolve(StyledLayerDescriptor.class, monitor);
                if (sld == null) continue;
                styles.add(sld);
            }
            return styles.toArray(new StyledLayerDescriptor[styles.size()]);
        }
        return super.resolve(adaptee, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List createMembers(ProgressListener monitor) throws IOException {
        if (this.members == null) {
            SLDService sLDService = this;
            synchronized (sLDService) {
                if (this.members == null) {
                    this.members = new ArrayList();
                    if (this.getFile().isDirectory()) {
                        File[] files = this.getFile().listFiles(new FileFilter(){

                            public boolean accept(File pathname) {
                                return SLDServiceFactory.isSLDFile(pathname);
                            }
                        });
                        for (int i = 0; i < files.length; ++i) {
                            this.members.add(new SLDGeoResource(this, files[i]));
                        }
                    } else {
                        this.members.add(new SLDGeoResource(this, this.getFile()));
                    }
                }
            }
        }
        return this.members;
    }

    public ServiceInfo getInfo(ProgressListener monitor) throws IOException {
        try {
            return new DefaultServiceInfo("Styled Layer Descriptor", null, null, this.getFile().toURI(), null, new URI(SLDServiceFactory.SLD_NAMESPACE), null, null);
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }
}

