/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.defaults;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.geotools.catalog.Resolve;
import org.geotools.catalog.ResolveDelta;
import org.geotools.catalog.ResolveDeltaVisitor;

public class DefaultResolveDelta
implements ResolveDelta {
    private List children;
    private ResolveDelta.Kind kind = ResolveDelta.Kind.NO_CHANGE;
    private Resolve handle = null;
    private Resolve newHandle = null;

    public DefaultResolveDelta(Resolve handle, List changes) {
        this.kind = ResolveDelta.Kind.CHANGED;
        this.children = Collections.unmodifiableList(changes);
        this.handle = handle;
        if (this.kind == ResolveDelta.Kind.REPLACED) {
            throw new IllegalArgumentException("New handle required in replace event.");
        }
        this.newHandle = null;
    }

    public DefaultResolveDelta(Resolve handle, ResolveDelta.Kind kind) {
        this.kind = kind;
        this.children = NO_CHILDREN;
        this.handle = handle;
        if (kind == ResolveDelta.Kind.REPLACED) {
            throw new IllegalArgumentException("New handle required in replace event.");
        }
        this.newHandle = null;
    }

    public DefaultResolveDelta(Resolve handle, ResolveDelta.Kind kind, List changes) {
        this.kind = kind;
        if (changes == null) {
            changes = new ArrayList();
        }
        this.children = Collections.unmodifiableList(changes);
        this.handle = handle;
        if (kind == ResolveDelta.Kind.REPLACED) {
            throw new IllegalArgumentException("New handle required in replace event.");
        }
        this.newHandle = null;
    }

    public DefaultResolveDelta(Resolve handle, Resolve newHandle, List changes) {
        this.kind = ResolveDelta.Kind.REPLACED;
        if (changes == null) {
            changes = new ArrayList();
        }
        this.children = Collections.unmodifiableList(changes);
        this.handle = handle;
        this.newHandle = newHandle;
    }

    public void accept(ResolveDeltaVisitor visitor) throws IOException {
        visitor.visit((ResolveDelta)this);
        for (DefaultResolveDelta delta : this.children) {
            if (delta == null || !visitor.visit((ResolveDelta)delta)) continue;
            delta.accept(visitor);
        }
    }

    public List getChildren() {
        return this.children;
    }

    public List getChildren(Set kindMask) {
        ArrayList<DefaultResolveDelta> list = new ArrayList<DefaultResolveDelta>();
        for (DefaultResolveDelta delta : this.children) {
            if (delta == null || !kindMask.contains(delta.getKind())) continue;
            list.add(delta);
        }
        return list;
    }

    public ResolveDelta.Kind getKind() {
        return this.kind;
    }

    public Resolve getResolve() {
        return this.handle;
    }

    public Resolve getNewResolve() {
        return this.newHandle;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ResolveDelta: [");
        buffer.append(this.kind);
        if (this.handle != null) {
            buffer.append(",");
            buffer.append(this.handle);
        }
        if (this.newHandle != null) {
            buffer.append(",");
            buffer.append(this.newHandle);
        }
        if (this.children != null) {
            buffer.append("children [");
            for (int i = 0; i < this.children.size(); ++i) {
                DefaultResolveDelta delta = (DefaultResolveDelta)this.children.get(i);
                buffer.append(delta.getKind());
            }
            buffer.append("] ");
        }
        buffer.append("] ");
        return buffer.toString();
    }
}

