/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.catalog.AbstractService;
import org.geotools.catalog.Catalog;
import org.geotools.catalog.FeatureSourceGeoResource;
import org.geotools.catalog.GeoResource;
import org.geotools.catalog.ServiceInfo;
import org.geotools.catalog.defaults.DefaultServiceInfo;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.util.ProgressListener;

public class DataStoreService
extends AbstractService {
    DataStoreFactorySpi dataStoreFactory;
    DataStore dataStore;
    ServiceInfo info;

    public DataStoreService(Catalog parent, Map params, DataStoreFactorySpi dataStoreFactory) {
        super(parent, params);
        this.dataStoreFactory = dataStoreFactory;
    }

    public DataStoreFactorySpi getDataStoreFactory() {
        return this.dataStoreFactory;
    }

    public URI getIdentifier() {
        try {
            return new URI(this.dataStoreFactory.getDisplayName());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canResolve(Class adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(ServiceInfo.class) || adaptee.isAssignableFrom(List.class) || adaptee.isAssignableFrom(DataStore.class);
    }

    public Object resolve(Class adaptee, ProgressListener monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(ServiceInfo.class)) {
            return this.getInfo(monitor);
        }
        if (adaptee.isAssignableFrom(List.class)) {
            return this.members(monitor);
        }
        if (adaptee.isAssignableFrom(DataStore.class)) {
            return this.dataStore(monitor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List members(ProgressListener monitor) throws IOException {
        if (this.getMembers() == null) {
            DataStore dataStore;
            DataStore dataStore2 = dataStore = this.dataStore(monitor);
            synchronized (dataStore2) {
                if (this.getMembers() == null) {
                    ArrayList<GeoResource> members = new ArrayList<GeoResource>();
                    String[] typeNames = dataStore.getTypeNames();
                    for (int i = 0; i < typeNames.length; ++i) {
                        String typeName = typeNames[i];
                        GeoResource resource = this.createGeoResource(typeName, dataStore);
                        if (resource != null) {
                            members.add(resource);
                            continue;
                        }
                        String msg = "Unable to create resource for " + typeName;
                        logger.warning(msg);
                    }
                    this.setMembers(members);
                }
            }
        }
        return this.getMembers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo getInfo(ProgressListener monitor) throws IOException {
        if (this.info == null) {
            DataStore dataStore;
            DataStore dataStore2 = dataStore = this.dataStore(monitor);
            synchronized (dataStore2) {
                if (this.info == null) {
                    try {
                        this.info = this.createMetaData(dataStore, null);
                        this.setMessage(null);
                    }
                    catch (Throwable t) {
                        String msg = "Error retreiving medatata.";
                        logger.log(Level.SEVERE, msg, t);
                        this.setMessage(t);
                    }
                }
            }
        }
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataStore dataStore(ProgressListener monitor) {
        if (this.dataStore == null) {
            Class<?> clazz = this.dataStoreFactory.getClass();
            synchronized (clazz) {
                if (this.dataStore == null) {
                    try {
                        this.dataStore = this.dataStoreFactory.createDataStore(this.getConnectionParams());
                        if (this.dataStore == null) {
                            throw new NullPointerException();
                        }
                        this.setMessage(null);
                    }
                    catch (Throwable t) {
                        String msg = "Unable to resolve datastore";
                        logger.log(Level.SEVERE, msg, t);
                        this.setMessage(t);
                    }
                }
            }
        }
        return this.dataStore;
    }

    protected ServiceInfo createMetaData(DataStore dataStore, ProgressListener monitor) {
        return new DefaultServiceInfo(this.dataStoreFactory.getDisplayName(), this.dataStoreFactory.getDescription(), null, null, null, null, null, null);
    }

    protected GeoResource createGeoResource(String typeName, DataStore dataStore) {
        return new FeatureSourceGeoResource(this, typeName);
    }
}

