/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.ltw;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.util.LangUtil;
import org.aspectj.weaver.ICrossReferenceHandler;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.reflect.AnnotationFinder;
import org.aspectj.weaver.reflect.IReflectionWorld;
import org.aspectj.weaver.reflect.ReflectionBasedReferenceTypeDelegate;
import org.aspectj.weaver.reflect.ReflectionBasedReferenceTypeDelegateFactory;
import org.aspectj.weaver.reflect.ReflectionWorld;

public class LTWWorld
extends BcelWorld
implements IReflectionWorld {
    private AnnotationFinder annotationFinder;
    private ClassLoader loader;
    protected static final Class concurrentMapClass = LTWWorld.makeConcurrentMapClass();
    protected static Map bootstrapTypes = LTWWorld.makeConcurrentMap();
    private static final long serialVersionUID = 1L;

    public LTWWorld(ClassLoader loader, IMessageHandler handler, ICrossReferenceHandler xrefHandler) {
        super(loader, handler, xrefHandler);
        this.loader = loader;
        this.setBehaveInJava5Way(LangUtil.is15VMOrGreater());
        this.annotationFinder = ReflectionWorld.makeAnnotationFinderIfAny(loader, this);
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    protected ReferenceTypeDelegate resolveDelegate(ReferenceType ty) {
        String name = ty.getName();
        ReferenceTypeDelegate bootstrapLoaderDelegate = this.resolveIfBootstrapDelegate(ty);
        if (bootstrapLoaderDelegate != null) {
            return bootstrapLoaderDelegate;
        }
        return super.resolveDelegate(ty);
    }

    protected ReferenceTypeDelegate resolveIfBootstrapDelegate(ReferenceType ty) {
        ReferenceTypeDelegate rtd;
        String name = ty.getName();
        Reference bootRef = (Reference)bootstrapTypes.get(name);
        if (bootRef != null && (rtd = (ReferenceTypeDelegate)bootRef.get()) != null) {
            return rtd;
        }
        char fc = name.charAt(0);
        if ((fc == 'j' || fc == 'c' || fc == 'o' || fc == 's') && (name.startsWith("java") || name.startsWith("com.sun.") || name.startsWith("org.w3c") || name.startsWith("sun.") || name.startsWith("org.omg"))) {
            ReferenceTypeDelegate bootstrapLoaderDelegate = this.resolveReflectionTypeDelegate(ty, null);
            if (bootstrapLoaderDelegate != null) {
                bootstrapTypes.put(ty.getName(), new WeakReference<ReferenceTypeDelegate>(bootstrapLoaderDelegate));
            }
            return bootstrapLoaderDelegate;
        }
        return null;
    }

    private ReferenceTypeDelegate resolveReflectionTypeDelegate(ReferenceType ty, ClassLoader resolutionLoader) {
        ReflectionBasedReferenceTypeDelegate res = ReflectionBasedReferenceTypeDelegateFactory.createDelegate(ty, this, resolutionLoader);
        return res;
    }

    public void loadedClass(Class clazz) {
    }

    public AnnotationFinder getAnnotationFinder() {
        return this.annotationFinder;
    }

    public ResolvedType resolve(Class aClass) {
        return ReflectionWorld.resolve(this, aClass);
    }

    private static Map makeConcurrentMap() {
        if (concurrentMapClass != null) {
            try {
                return (Map)concurrentMapClass.newInstance();
            }
            catch (InstantiationException _) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return Collections.synchronizedMap(new HashMap());
    }

    private static Class makeConcurrentMapClass() {
        String[] betterChoices = new String[]{"java.util.concurrent.ConcurrentHashMap", "edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap", "EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap"};
        for (int i = 0; i < betterChoices.length; ++i) {
            try {
                return Class.forName(betterChoices[i]);
            }
            catch (ClassNotFoundException _) {
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isRunMinimalMemory() {
        return true;
    }
}

