/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.gisgraphoid;

import android.util.Log;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;

public class RestClient {
    private static final String ENCODING = "UTF-8";
    private String webServiceUrl;

    public RestClient(String webServiceUrl) {
        System.setProperty("http.agent", "gisgraphoid-1.0");
        if (webServiceUrl == null) {
            throw new IllegalArgumentException("can not create a restclient for null URL");
        }
        if (!webServiceUrl.endsWith("/")) {
            webServiceUrl = webServiceUrl + "/";
        }
        this.webServiceUrl = webServiceUrl;
    }

    public <T> T get(String methodName, Class<T> classToBeBound, Map<String, String> params) {
        if (methodName == null) {
            methodName = "";
        }
        if (methodName.startsWith("/")) {
            methodName = methodName.substring(1);
        }
        String getUrl = this.getWebServiceUrl() + methodName;
        int i = 0;
        StringBuffer sb = new StringBuffer(getUrl);
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (i == 0) {
                    sb.append("?");
                } else {
                    sb.append("&");
                }
                try {
                    sb.append(param.getKey()).append("=").append(URLEncoder.encode(param.getValue(), ENCODING));
                }
                catch (UnsupportedEncodingException e) {
                    Log.e((String)"RestClient", (String)("can not encode REST URL : " + e));
                }
                ++i;
            }
        }
        String urlWithQueryString = sb.toString();
        Log.d((String)"RestClient: ", (String)("getUrl = " + urlWithQueryString));
        try {
            InputStream in = this.getRemoteContent(urlWithQueryString);
            Object returnObjects = new Gson().fromJson((Reader)new BufferedReader(new InputStreamReader(in)), classToBeBound);
            return (T)returnObjects;
        }
        catch (Exception e) {
            String errorMessage = "Error during parsing of Gisgraphy response (has Gisgraphy API changed or feed is not json ?) : " + e;
            Log.d((String)"RestClient", (String)errorMessage, (Throwable)e);
            return null;
        }
    }

    private InputStream getRemoteContent(String urlString) throws IOException {
        URL url;
        if (urlString == null) {
            throw new IOException("can not retrieve the content of a null url");
        }
        InputStream in = null;
        int responseCode = -1;
        try {
            url = new URL(urlString);
        }
        catch (Exception e) {
            throw new IOException(urlString + " is not a valid url");
        }
        URLConnection conn = url.openConnection();
        if (!(conn instanceof HttpURLConnection)) {
            throw new IOException("Not an HTTP connection");
        }
        HttpURLConnection httpConn = (HttpURLConnection)conn;
        httpConn.setAllowUserInteraction(false);
        httpConn.setInstanceFollowRedirects(true);
        httpConn.setRequestMethod("GET");
        httpConn.connect();
        responseCode = httpConn.getResponseCode();
        if (responseCode != 200) {
            String errorMessage = "calling " + urlString + " return an error : " + responseCode;
            Log.e((String)"Restclient", (String)errorMessage);
            throw new IOException(errorMessage);
        }
        in = httpConn.getInputStream();
        return in;
    }

    public String getWebServiceUrl() {
        return this.webServiceUrl;
    }
}

