/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.gisgraphoid;

import com.gisgraphy.domain.valueobject.SRID;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class JTSHelper {
    public static Point createPoint(Float longitude, Float latitude) {
        if (longitude.floatValue() < -180.0f || longitude.floatValue() > 180.0f) {
            throw new IllegalArgumentException("Longitude should be between -180 and 180");
        }
        if (latitude.floatValue() < -90.0f || latitude.floatValue() > 90.0f) {
            throw new IllegalArgumentException("latitude should be between -90 and 90");
        }
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), SRID.WGS84_SRID.getSRID());
        Point point = factory.createPoint(new Coordinate((double)longitude.floatValue(), (double)latitude.floatValue()));
        return point;
    }

    public static boolean checkLatitude(double latitude) {
        if (latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("latitude is out of bound");
        }
        return true;
    }

    public static boolean checkLongitude(double longitude) {
        if (longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("longitude is out of bound");
        }
        return true;
    }

    public static Float parseInternationalDouble(String number) throws ParseException {
        NumberFormat nffrench = NumberFormat.getInstance(Locale.FRENCH);
        NumberFormat nfus = NumberFormat.getInstance(Locale.US);
        Number numberToReturn = number.indexOf(44) != -1 ? (Number)nffrench.parse(number) : (Number)nfus.parse(number);
        return Float.valueOf(numberToReturn.floatValue());
    }
}

