/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.gisgraphoid;

import android.content.Context;
import android.location.Address;
import android.util.Log;
import com.gisgraphy.addressparser.AddressResultsDto;
import com.gisgraphy.domain.valueobject.StreetSearchResultsDto;
import com.gisgraphy.gisgraphoid.AndroidAddressBuilder;
import com.gisgraphy.gisgraphoid.JTSHelper;
import com.gisgraphy.gisgraphoid.RestClient;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class GisgraphyGeocoder {
    private static String LOG_TAG = GisgraphyGeocoder.class.getSimpleName();
    protected AndroidAddressBuilder addressBuilder;
    protected static final String APIKEY_PARAMETER_NAME = "apikey";
    protected static final String ADDRESS_PARAMETER_NAME = "address";
    protected static final String COUNTRY_PARAMETER_NAME = "country";
    protected static final String FORMAT_PARAMETER_NAME = "format";
    protected static final String LATITUDE_PARAMETER_NAME = "lat";
    protected static final String LONGITUDE_PARAMETER_NAME = "lng";
    public static final String DEFAULT_BASE_URL = "http://services.gisgraphy.com/";
    protected static final String DEFAULT_FORMAT = "json";
    public static final String GEOCODING_URI = "geocoding/geocode";
    public static final String REVERSE_GEOCODING_URI = "street/streetsearch";
    private Locale locale = Locale.getDefault();
    private Long apiKey;
    private String baseUrl = "http://services.gisgraphy.com/";

    protected void log_d(String message) {
        Log.d((String)LOG_TAG, (String)message);
    }

    static boolean isPresent() {
        return true;
    }

    public void setBaseUrl(String url) {
        if (url == null) {
            throw new IllegalArgumentException(LOG_TAG + " does not accept null URL");
        }
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(url + " is no a valid Url : " + e.getMessage(), e);
        }
        this.baseUrl = url;
    }

    public GisgraphyGeocoder(Context context, Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException(LOG_TAG + " does not accept null locale");
        }
        this.locale = locale;
        this.addressBuilder = new AndroidAddressBuilder(locale);
    }

    public GisgraphyGeocoder(Context context, Locale locale, String url) {
        if (locale == null) {
            throw new IllegalArgumentException(LOG_TAG + " does not accept null locale");
        }
        this.setBaseUrl(url);
        this.locale = locale;
        this.addressBuilder = new AndroidAddressBuilder(locale);
    }

    public GisgraphyGeocoder(Context context) {
        this.addressBuilder = new AndroidAddressBuilder();
    }

    public GisgraphyGeocoder(Context context, String url) {
        this.locale = Locale.getDefault();
        this.addressBuilder = new AndroidAddressBuilder(this.locale);
        this.setBaseUrl(url);
    }

    public List<Address> getFromLocation(double latitude, double longitude, int maxResults) throws IOException {
        this.log_d("getFromLocation: lat=" + latitude + ",longitude=" + longitude + ",maxResults=" + maxResults);
        if (!JTSHelper.checkLatitude(latitude) || !JTSHelper.checkLatitude(longitude)) {
            throw new IllegalArgumentException("lattitude should be > -90 and < 90 and longitude should be >-180 and < 180");
        }
        if (maxResults < 0) {
            throw new IllegalArgumentException("maxResults should be positive");
        }
        if (maxResults == 0) {
            return new ArrayList<Address>();
        }
        List<Address> androidAddresses = new ArrayList<Address>();
        try {
            StreetSearchResultsDto response;
            RestClient webService = this.createRestClient();
            HashMap<String, String> params = new HashMap<String, String>();
            this.log_d("lat=" + latitude + ", long=" + longitude);
            params.put(LATITUDE_PARAMETER_NAME, latitude + "");
            params.put(LONGITUDE_PARAMETER_NAME, longitude + "");
            params.put(FORMAT_PARAMETER_NAME, DEFAULT_FORMAT);
            if (this.apiKey != null) {
                params.put(APIKEY_PARAMETER_NAME, this.apiKey + "");
            }
            if ((response = webService.get(REVERSE_GEOCODING_URI, StreetSearchResultsDto.class, params)) != null && response.getResult() != null && response.getResult().size() > 0) {
                androidAddresses = this.addressBuilder.transformStreetsToAndroidAddresses(response.getResult());
            }
            if (androidAddresses.size() > maxResults) {
                return androidAddresses.subList(0, maxResults);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return androidAddresses;
    }

    public List<Address> getFromLocationName(String locationName, int maxResults, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude) throws IOException {
        this.log_d("getFromLocationName: locationName=" + locationName + ",maxResults=" + maxResults + ",lowerLeftLatitude=" + lowerLeftLatitude + ",lowerLeftLongitude=" + lowerLeftLongitude + ",upperRightLatitude=" + upperRightLatitude + ",upperRightLongitude=" + upperRightLongitude);
        if (!(JTSHelper.checkLatitude(lowerLeftLatitude) && JTSHelper.checkLatitude(upperRightLatitude) && JTSHelper.checkLongitude(upperRightLongitude) && JTSHelper.checkLongitude(lowerLeftLongitude))) {
            throw new IllegalArgumentException("lattitude should be > -90 and < 90 and longitude should be >-180 and < 180");
        }
        if (maxResults < 0) {
            throw new IllegalArgumentException("maxResults should be positive");
        }
        if (maxResults == 0) {
            return new ArrayList<Address>();
        }
        List<Address> androidAddresses = this.getFromLocationName(locationName, 1000);
        for (int i = 0; i < androidAddresses.size(); ++i) {
            Address address = androidAddresses.get(i);
            if (!(address.getLatitude() < lowerLeftLatitude || address.getLatitude() > upperRightLatitude || address.getLongitude() < lowerLeftLongitude) && !(address.getLongitude() > upperRightLongitude)) continue;
            androidAddresses.remove(i);
        }
        if (androidAddresses.size() > maxResults) {
            return androidAddresses.subList(0, maxResults);
        }
        return androidAddresses;
    }

    public List<Address> getFromLocationName(String locationName, int maxResults) throws IOException {
        this.log_d("getFromLocationName: locationName=" + locationName + ",maxResults=" + maxResults);
        if (locationName == null) {
            throw new IllegalArgumentException("can not geocode a null location name ");
        }
        if (maxResults < 0) {
            throw new IllegalArgumentException("maxResults should be positive");
        }
        try {
            AddressResultsDto response;
            this.checkUrl();
            List<Address> androidAddresses = new ArrayList<Address>();
            if (maxResults == 0) {
                return androidAddresses;
            }
            RestClient webService = this.createRestClient();
            HashMap<String, String> params = new HashMap<String, String>();
            String iso2countryCode = this.locale.getCountry();
            this.log_d("locationName='" + locationName + "'");
            this.log_d("country='" + iso2countryCode + "'");
            params.put(COUNTRY_PARAMETER_NAME, iso2countryCode);
            params.put(ADDRESS_PARAMETER_NAME, locationName);
            params.put(FORMAT_PARAMETER_NAME, DEFAULT_FORMAT);
            if (this.apiKey != null) {
                params.put(APIKEY_PARAMETER_NAME, this.apiKey + "");
            }
            if ((response = webService.get(GEOCODING_URI, AddressResultsDto.class, params)) != null && response.getResult() != null && response.getResult().size() > 0) {
                androidAddresses = this.addressBuilder.transformGisgraphyAddressesToAndroidAddresses(response.getResult());
            }
            if (androidAddresses.size() > maxResults) {
                return androidAddresses.subList(0, maxResults);
            }
            return androidAddresses;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected RestClient createRestClient() {
        return new RestClient(this.baseUrl);
    }

    private void checkUrl() throws IOException {
        if (this.baseUrl == null) {
            throw new IOException(this.getClass().getSimpleName() + " is not initialize, please call setUrl before calling geocoding methods");
        }
    }

    public Long getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(Long apiKey) {
        this.apiKey = apiKey;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

