/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.gisgraphoid;

import android.location.Address;
import com.gisgraphy.domain.valueobject.CountriesStaticData;
import com.gisgraphy.domain.valueobject.StreetDistance;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class AndroidAddressBuilder {
    protected static final String STREET_BASE_URL = "http://services.gisgraphy.com/public/displaystreet.html?gid=";
    private Locale locale;

    public AndroidAddressBuilder(Locale locale) {
        this.locale = locale;
    }

    public AndroidAddressBuilder() {
        this.locale = Locale.getDefault();
    }

    public List<Address> transformGisgraphyAddressesToAndroidAddresses(List<com.gisgraphy.addressparser.Address> gisgraphyAddresses) {
        ArrayList<Address> androidAddresses = new ArrayList<Address>();
        if (gisgraphyAddresses != null) {
            for (com.gisgraphy.addressparser.Address address : gisgraphyAddresses) {
                Address androidAddress = this.transformGisgraphyAddressToAndroidAddress(address);
                if (androidAddress == null) continue;
                androidAddresses.add(androidAddress);
            }
        }
        return androidAddresses;
    }

    public Address transformGisgraphyAddressToAndroidAddress(com.gisgraphy.addressparser.Address gisgraphyAddress) {
        Address androidAddress = new Address(this.locale);
        String countryCode = this.locale.getCountry();
        androidAddress.setCountryCode(countryCode);
        androidAddress.setCountryName(CountriesStaticData.getCountryNameFromCountryCode((String)countryCode));
        androidAddress.setLatitude(gisgraphyAddress.getLat().doubleValue());
        androidAddress.setLongitude(gisgraphyAddress.getLng().doubleValue());
        if (gisgraphyAddress.getStreetName() != null) {
            androidAddress.setFeatureName(gisgraphyAddress.getStreetName());
            androidAddress.setAddressLine(0, this.ComputeStreetLine(gisgraphyAddress));
            androidAddress.setAddressLine(1, this.computeCityLine(gisgraphyAddress));
        } else if (gisgraphyAddress.getCity() != null) {
            androidAddress.setFeatureName(gisgraphyAddress.getCity());
            androidAddress.setAddressLine(0, this.computeCityLine(gisgraphyAddress));
        }
        androidAddress.setLocality(gisgraphyAddress.getCity());
        androidAddress.setAdminArea(gisgraphyAddress.getState());
        androidAddress.setPostalCode(gisgraphyAddress.getZipCode());
        androidAddress.setUrl(this.buildAddressUrlFromGisgraphyAddress(gisgraphyAddress));
        return androidAddress;
    }

    private String ComputeStreetLine(com.gisgraphy.addressparser.Address gisgraphyAddress) {
        if (gisgraphyAddress.getStreetName() != null) {
            return gisgraphyAddress.getStreetName();
        }
        return null;
    }

    private String computeCityLine(com.gisgraphy.addressparser.Address gisgraphyAddress) {
        String line1;
        String countryName;
        StringBuffer sb = new StringBuffer();
        if (gisgraphyAddress.getZipCode() != null) {
            sb.append(gisgraphyAddress.getZipCode()).append(" ");
        }
        if (gisgraphyAddress.getCity() != null) {
            sb.append(gisgraphyAddress.getCity()).append(" ");
        }
        if (gisgraphyAddress.getState() != null) {
            sb.append(gisgraphyAddress.getState()).append(" ");
        }
        if (gisgraphyAddress.getCountryCode() != null && (countryName = CountriesStaticData.getCountryNameFromCountryCode((String)gisgraphyAddress.getCountryCode())) != null) {
            sb.append(countryName).append(" ");
        }
        if ((line1 = sb.toString()).trim().length() != 0) {
            return line1.trim();
        }
        return null;
    }

    protected String buildAddressUrlFromGisgraphyAddress(com.gisgraphy.addressparser.Address gisgraphyAddress) {
        if (gisgraphyAddress != null && gisgraphyAddress.getId() != null) {
            return STREET_BASE_URL + gisgraphyAddress.getId();
        }
        return null;
    }

    protected String buildAddressUrlFromStreetDistance(StreetDistance street) {
        if (street != null && street.getGid() != null) {
            return STREET_BASE_URL + street.getGid();
        }
        return null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public List<Address> transformStreetsToAndroidAddresses(List<StreetDistance> streets) {
        ArrayList<Address> androidAddresses = new ArrayList<Address>();
        if (streets != null) {
            for (StreetDistance street : streets) {
                Address androidAddress = this.transformStreetToAndroidAddress(street);
                if (street == null) continue;
                androidAddresses.add(androidAddress);
            }
        }
        return androidAddresses;
    }

    public Address transformStreetToAndroidAddress(StreetDistance street) {
        Address androidAddress = new Address(this.locale);
        androidAddress.setLatitude(street.getLat().doubleValue());
        androidAddress.setLongitude(street.getLng().doubleValue());
        String countryCode = street.getCountryCode();
        androidAddress.setCountryName(CountriesStaticData.getCountryNameFromCountryCode((String)countryCode));
        androidAddress.setCountryCode(countryCode);
        androidAddress.setFeatureName(street.getName());
        androidAddress.setLocality(street.getIsIn());
        androidAddress.setUrl(this.buildAddressUrlFromStreetDistance(street));
        androidAddress.setAddressLine(0, street.getName());
        androidAddress.setAddressLine(1, this.buildAddressLine1(street));
        return androidAddress;
    }

    private String buildAddressLine1(StreetDistance streetDistance) {
        if (streetDistance != null) {
            String countryName;
            StringBuffer sb = new StringBuffer();
            if (streetDistance.getIsIn() != null) {
                sb.append(streetDistance.getIsIn()).append(" ");
            }
            if (streetDistance.getCountryCode() != null && (countryName = CountriesStaticData.getCountryNameFromCountryCode((String)streetDistance.getCountryCode())) != null) {
                sb.append(countryName).append(" ");
            }
            return sb.toString();
        }
        return null;
    }
}

